<?php
// Database connection
include '../../connection.php'; 

$id = $_GET['id'] ?? 0;
$sql = "SELECT * FROM manual_add_money WHERE id = ?";

$stmt = $con->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $taka = $_POST['taka'];
    $status = $_POST['status'];

    // Update the manual_add_money table
    $update_sql = "UPDATE manual_add_money SET taka = ?, status = ? WHERE id = ?";
    $update_stmt = $con->prepare($update_sql);
    $update_stmt->bind_param("ssi", $taka, $status, $id);
    $update_stmt->execute();

    // If the status is 'Accepted'
    if ($status === 'Accepted') {
        $userid = $row['userid']; // Assuming the userid is in the fetched row

        // Check if the user already exists in the balance table
        $balance_sql = "SELECT amount FROM balance WHERE userid = ?";
        $balance_stmt = $con->prepare($balance_sql);
        $balance_stmt->bind_param("i", $userid);
        $balance_stmt->execute();
        $balance_result = $balance_stmt->get_result();

        if ($balance_result->num_rows > 0) {
            // User exists, update the amount
            $current_amount = $balance_result->fetch_assoc()['amount'];
            $new_amount = $current_amount + $taka;

            $update_balance_sql = "UPDATE balance SET amount = ? WHERE userid = ?";
            $update_balance_stmt = $con->prepare($update_balance_sql);
            $update_balance_stmt->bind_param("di", $new_amount, $userid);
            $update_balance_stmt->execute();
        } else {
            // User does not exist, insert a new record
            $insert_balance_sql = "INSERT INTO balance (userid, amount) VALUES (?, ?)";
            $insert_balance_stmt = $con->prepare($insert_balance_sql);
            $insert_balance_stmt->bind_param("id", $userid, $taka);
            $insert_balance_stmt->execute();
        }

        // Insert notification for accepted status
        $message = ' এডমিন  আপনার ম্যানুয়াল  এ্যাড মানি রিকোয়েস্টটি   গ্রহণ ও সম্পন্ন করেছেন ';
        $notificationStatus = 'Unread';
        $date = date('Y-m-d'); // Get current date and time

        $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date) VALUES (?, ?, ?, ?)";
        $stmtInsertNotification = $con->prepare($sqlInsertNotification);

        if ($stmtInsertNotification === false) {
            die('Prepare failed: ' . htmlspecialchars($con->error));
        }

        $stmtInsertNotification->bind_param("isss", $userid, $message, $notificationStatus, $date);
        $stmtInsertNotification->execute();
        $stmtInsertNotification->close();
    } elseif ($status === 'Rejected') {
        // Insert notification for rejected status
        $message = ' এডমিন  আপনার ম্যানুয়াল এ্যাড মানি রিকোয়েস্টটি   বাতিল করেছেন ';
        $notificationStatus = 'Unread';
        $date = date('Y-m-d'); // Get current date and time

        $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date) VALUES (?, ?, ?, ?)";
        $stmtInsertNotification = $con->prepare($sqlInsertNotification);

        if ($stmtInsertNotification === false) {
            die('Prepare failed: ' . htmlspecialchars($con->error));
        }

        $stmtInsertNotification->bind_param("isss", $userid, $message, $notificationStatus, $date);
        $stmtInsertNotification->execute();
        $stmtInsertNotification->close();
    }

    header("Location: add-bal-rqst-manual.php"); 
    exit();
}
?>


<?php include 'header-link.php' ?>
<?php include 'nav-bar.php' ?>
<?php include 'header-top-chat.php' ?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ breadcrumb ] start -->
                        <div class="page-header text-center">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10"> Add Balance Approval</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] start -->
                        <div class="row justify-content-center">
                            <!-- [ form-element ] start -->
                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Add Balance Approval</h5>
                                    </div>
                                    <div class="card-body">
                                        <form method="POST">
										
											 <div class="form-group">
                                                <label class="form-label"> Bank Name </label>
                                                <input type="text" name="Bank" class="form-control" value="<?php echo $row['bank_name']; ?>" required>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label"> Tranx Id </label>
                                                <input type="text" name="number" class="form-control" value="<?php echo $row['trans_id']; ?>" required>
                                            </div>
											
                                            <div class="form-group">
                                                <label class="form-label"> Amount </label>
                                                <input type="text" name="taka" class="form-control" value="<?php echo $row['taka']; ?>" required>
                                            </div>
                                           
                                            <div class="form-group">
                                                <label class="form-label"> Choose Status </label>
                                                <select name="status" class="form-select form-control" required>
                                                    <option value="Pending" <?php echo $row['status'] === 'Pending' ? 'selected' : ''; ?>>Pending</option>
                                                    <option value="Accepted" <?php echo $row['status'] === 'Accepted' ? 'selected' : ''; ?>>Accepted</option>
                                                    <option value="Rejected" <?php echo $row['status'] === 'Rejected' ? 'selected' : ''; ?>>Rejected</option>
                                                    
                                                </select>
                                            </div>
                                            <div class="card-footer">
                                                <button type="submit" class="btn btn-primary me-2">Submit</button>
                                                <a class="btn btn-light" href="add-bal-rqst-manual.php"> Go Back </a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- [ Main Content ] end -->

<?php include 'footer.php' ?>
